package actions;

import entitats.Client;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;

public class Alta extends Action {
    
    DataSource ds = null;
    Connection con = null;
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        
        Client client = (Client) form;
        
        try{
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = null;
            PreparedStatement sentencia = null;
            //Comprovem si el client sera una empresa o una persona miran't si el cognom esta omplert o no
            if (client.getCognoms() == null)
                client.setTipus("empresa");
            else
                client.setTipus("persona");
            
            //Comprova primer si introduim el client com a propietari i si existeix com a tal.
            if (request.getSession().getAttribute("usuariagent") != null) {
                rs = st.executeQuery("SELECT * FROM clients WHERE nif = '"+client.getNif()+"'");
                if (rs.next()) {
                    if (rs.getBoolean("es_propietari")) {
                        client.setError("<font color='red'>NIF ja existent a la base de dades</font>");
                        return mapping.findForward("ok");
                        //En cas de ser un propietari q existeix com a propietari, es fa la modificacio a la bd per donar-lo d'alta.
                    } else {
                        st.executeUpdate("UPDATE clients SET es_propietari = 1 WHERE nif = '"+client.getNif()+"'");
                        client.setError("<font color='blue'>El client existia com a llogater, ha estat donat d'alta com a propietari</font>");
                        return mapping.findForward("ok");
                    }
                }
            }
            
            //Comprova primer si introduim el client com a llogater i si existeix com a tal.
            if (request.getSession().getAttribute("usuarivenedor") != null) {
                rs = st.executeQuery("SELECT * FROM clients WHERE nif = '"+client.getNif()+"'");
                if (rs.next()) {
                    if (rs.getBoolean("es_llogater")) {
                        client.setError("<font color='red'>NIF ja existent a la base de dades</font>");
                        return mapping.findForward("ok");
                        //En cas de ser un llogater q existeix com a propietari, es fa la modificacio a la bd per donar-lo d'alta.
                    } else {
                        st.executeUpdate("UPDATE clients SET es_llogater = 1 WHERE nif = '"+client.getNif()+"'");
                        client.setError("<font color='blue'>El client existia com a propietari, ha estat donat d'alta com a llogater</font>");
                        return mapping.findForward("ok");
                    }
                }
            }
            
            //Introduiex l'usuari a la base de dades
            sentencia = con.prepareStatement("INSERT INTO clients (nif, nom_o_rao_social, cognoms, telefon, adresa, es_propietari, es_llogater, tipus) VALUES (?,?,?,?,?,?,?,?)");
            sentencia.setString(1, client.getNif());
            sentencia.setString(2, client.getNom());
            sentencia.setString(3, client.getCognoms());
            sentencia.setString(4, client.getTelefon());
            sentencia.setString(5, client.getAdresa());
            if (request.getSession().getAttribute("usuariagent") != null) {
                sentencia.setBoolean(6, true);
                sentencia.setBoolean(7, false);
            }
            if (request.getSession().getAttribute("usuarivenedor") != null) {
                sentencia.setBoolean(6, false);
                sentencia.setBoolean(7, true);
            }
            sentencia.setString(8, client.getTipus());
            sentencia.executeUpdate();
            
            client.setError("<font color='blue'>Propietari afegit satisfactoriament<br></font>");
            return mapping.findForward("ok");
            
        }catch(Exception excepcio){
            client.setError("<font color='red'>Excepcio ocorreguda en actions.altaPropietari:<br>" +
                    ""+excepcio.getMessage()+"</font>");
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                client.setError("<font color='red'>Excepcio ocorreguda en actions.Propietari:<br>" +
                        ""+excepcio.getMessage()+"</font>");
                return mapping.findForward("ok");
            }
        }
        
        return mapping.findForward("ok");
        
        
        
    }
}
